﻿using EAT_IT.Data;

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.Graphics.Display;
using Windows.UI.ViewManagement;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Windows.Storage;
using Callisto.Callisto_XamlTypeInfo;
using Callisto.Controls;
using Callisto.Controls.Common;
using Callisto.Effects;

// Die Elementvorlage "Geteilte Seite" ist unter http://go.microsoft.com/fwlink/?LinkId=234234 dokumentiert.

namespace EAT_IT
{
    /// <summary>
    /// Eine Seite, auf der ein Gruppentitel, eine Liste mit Elementen innerhalb der Gruppe sowie Details für das
    /// momentan ausgewählte Element angezeigt werden.
    /// </summary>
    public sealed partial class SplitPage : EAT_IT.Common.LayoutAwarePage
    {
        List<string> GeloeschteRezepte;
        public SplitPage()
        {
            this.InitializeComponent();


        }

        #region Verwaltung des Seitenzustands

        /// <summary>
        /// Füllt die Seite mit Inhalt auf, der bei der Navigation übergeben wird. Gespeicherte Zustände werden ebenfalls
        /// bereitgestellt, wenn eine Seite aus einer vorherigen Sitzung neu erstellt wird.
        /// </summary>
        /// <param name="navigationParameter">Der Parameterwert, der an
        /// <see cref="Frame.Navigate(Type, Object)"/> übergeben wurde, als diese Seite ursprünglich angefordert wurde.
        /// </param>
        /// <param name="pageState">Ein Wörterbuch des Zustands, der von dieser Seite während einer früheren Sitzung
        /// beibehalten wurde. Beim ersten Aufrufen einer Seite ist dieser Wert NULL.</param>
        protected override void LoadState(Object navigationParameter, Dictionary<String, Object> pageState)
        {
            // TODO: Ein geeignetes Datenmodell für die problematische Domäne erstellen, um die Beispieldaten auszutauschen
            //Geloescht.IsEnabled = false;
            
            GeloeschteRezepte = new List<string>();
            var group = SampleDataSource.GetGroup((String)navigationParameter);
            this.DefaultViewModel["Group"] = group;
            this.DefaultViewModel["Items"] = group.Items;
            if ((String)navigationParameter == "Tagesgerichte")
                Speichern.Visibility = Windows.UI.Xaml.Visibility.Visible;
            if ((String)navigationParameter == "EigeneRezepte")
            {
                Loeschen.Visibility = Windows.UI.Xaml.Visibility.Visible;
                Rate.Visibility = Windows.UI.Xaml.Visibility.Visible;
                NeuErstellen.Visibility = Windows.UI.Xaml.Visibility.Visible;
            }
           

            if (pageState == null)
            {
                this.itemListView.SelectedItem = null;
                // Wenn es sich hierbei um eine neue Seite handelt, das erste Element automatisch auswählen, außer wenn
                // logische Seitennavigation verwendet wird (weitere Informationen in der #Region zur logischen Seitennavigation unten).
                if (!this.UsingLogicalPageNavigation() && this.itemsViewSource.View != null)
                {
                    this.itemsViewSource.View.MoveCurrentToFirst();
                }
            }
            else
            {
                // Den zuvor gespeicherten Zustand wiederherstellen, der dieser Seite zugeordnet ist
                if (pageState.ContainsKey("SelectedItem") && this.itemsViewSource.View != null)
                {
                    var selectedItem = SampleDataSource.GetItem((String)pageState["SelectedItem"]);
                    this.itemsViewSource.View.MoveCurrentTo(selectedItem);
                }

            }
            if (itemsViewSource.View.Count == 0)
            { 
                Loeschen.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
            Rate.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
            }


        }

        /// <summary>
        /// Behält den dieser Seite zugeordneten Zustand bei, wenn die Anwendung angehalten oder
        /// die Seite im Navigationscache verworfen wird. Die Werte müssen den Serialisierungsanforderungen
        /// von <see cref="SuspensionManager.SessionState"/> entsprechen.
        /// </summary>
        /// <param name="pageState">Ein leeres Wörterbuch, das mit dem serialisierbaren Zustand aufgefüllt wird.</param>
        protected override void SaveState(Dictionary<String, Object> pageState)
        {
            if (this.itemsViewSource.View != null)
            {
                var selectedItem = (SampleDataItem)this.itemsViewSource.View.CurrentItem;
                if (selectedItem != null) pageState["SelectedItem"] = selectedItem.UniqueId;
            }
        }

        #endregion

        #region Logische Seitennavigation

        // Die visuelle Zustandsverwaltung gibt die vier Ansichtszustände für Anwendungen normalerweise direkt wieder
        // (Vollbild im Querformat und Hochformat sowie angedockte und gefüllte Ansicht). Die geteilte Seite
        // wurde so entworfen, dass die angedockte Ansicht und das Querformat jeweils über zwei verschiedene Unterzustände verfügen:
        // entweder die Elementliste oder die Details werden angezeigt, jedoch nicht beides gleichzeitig.
        //
        // All dies wird mit einer einzigen physischen Seite implementiert, die zwei logische Seiten darstellen
        // kann. Mit dem nachfolgenden Code wird dieses Ziel erreicht, ohne dass der Benutzer aufmerksam gemacht wird auf den
        // Unterschied.

        /// <summary>
        /// Wird aufgerufen, um zu bestimmen, ob die Seite als eine logische Seite oder zwei agieren soll.
        /// </summary>
        /// <param name="viewState">Der Ansichtszustand, für den die Frage gestellt wird, oder NULL
        /// für den aktuellen Ansichtszustand. Dieser Parameter ist optional mit NULL als standardmäßigem
        /// Wert.</param>
        /// <returns>"True", wenn der fragliche Ansichtszustand Hochformat oder angedockt ist, "false"
        /// in anderen Fällen.</returns>
        private bool UsingLogicalPageNavigation(ApplicationViewState? viewState = null)
        {
            if (viewState == null) viewState = ApplicationView.Value;
            return viewState == ApplicationViewState.FullScreenPortrait ||
                viewState == ApplicationViewState.Snapped;
        }

        /// <summary>
        /// Wird aufgerufen, wenn ein Element innerhalb der Liste ausgewählt wird.
        /// </summary>
        /// <param name="sender">GridView (oder ListView, wenn die Anwendung angedockt ist),
        /// die das ausgewählte Element anzeigt.</param>
        /// <param name="e">Ereignisdaten, die beschreiben, wie die Auswahl geändert wurde.</param>
        void ItemListView_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {

            var selectedItem = (SampleDataItem)this.itemsViewSource.View.CurrentItem;
            if(selectedItem!=null)
                Rate.Value = selectedItem.Rating;
            Speichern.Visibility = Windows.UI.Xaml.Visibility.Visible;
            

            // Der Speichern-Button soll versteckt werden, falls das Element bereits gespeichert wurde.
            var Gruppe2 = SampleDataSource.GetGroups();
            var vergleich = (SampleDataItem)this.itemsViewSource.View.CurrentItem;
            if (vergleich != null)
            {
                foreach (var element in Gruppe2)
                {
                    if (vergleich.Title == element.Title && vergleich.Description == element.Description)
                        Speichern.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
                }
            }
            // Den Ansichtszustand ungültig machen, wenn die logische Seitennavigation wirksam ist, da eine Änderung an der
            // Auswahl zu einer entsprechenden Änderung an der aktuellen logischen Seite führen kann. Wenn
            // ein Element ausgewählt wird, führt dies dazu, dass anstelle der Elementliste
            // die Details des ausgewählten Elements angezeigt werden. Wenn die Auswahl aufgehoben wird, hat
            // dies den umgekehrten Effekt.
            if (this.UsingLogicalPageNavigation()) this.InvalidateVisualState();
        }

        /// <summary>
        /// Wird aufgerufen, wenn auf die Schaltfläche "Zurück" der Seite geklickt wird.
        /// </summary>
        /// <param name="sender">Die Instanz der Schaltfläche "Zurück".</param>
        /// <param name="e">Ereignisdaten, die beschreiben, wie auf die Schaltfläche "Zurück" geklickt wurde.</param>
        protected override void GoBack(object sender, RoutedEventArgs e)
        {

            this.Frame.Navigate(typeof(ItemsPage), "AllGroups");

        }

        /// <summary>
        /// Wird aufgerufen, um den Namen des visuellen Zustands zu bestimmen, der dem Ansichtszustand einer Anwendung
        /// entspricht.
        /// </summary>
        /// <param name="viewState">Der Ansichtszustand, für den die Frage gestellt wird.</param>L
        /// <returns>Der Name des gewünschten visuellen Zustands. Dieser ist identisch mit dem Namen des
        /// Ansichtszustands, außer wenn ein ausgewähltes Element im Hochformat und in der angedockten Ansicht vorliegt, wobei
        /// diese zusätzliche logische Seite durch Hinzufügen des Suffix _Detail dargestellt wird.</returns>
        protected override string DetermineVisualState(ApplicationViewState viewState)
        {
            // Den Aktivierungszustand der Schaltfläche "Zurück" aktualisieren, wenn der Ansichtszustand geändert wird
            var logicalPageBack = this.UsingLogicalPageNavigation(viewState) && this.itemListView.SelectedItem != null;
            var physicalPageBack = this.Frame != null && this.Frame.CanGoBack;
            this.DefaultViewModel["CanGoBack"] = logicalPageBack || physicalPageBack;

            // Visuelle Zustände für Querformatlayouts nicht auf dem Ansichtszustand, sondern der Breite
            // des Fensters basierend festlegen. Für diese Seite gibt es ein Layout, das für
            // 1366 virtuelle Pixel oder breiter geeignet ist, und ein anderes für schmalere Anzeigen oder wenn eine angedockte
            // Anwendung den verfügbaren horizontalen Raum auf weniger als 1366 Pixel reduziert.
            if (viewState == ApplicationViewState.Filled ||
                viewState == ApplicationViewState.FullScreenLandscape)
            {
                var windowWidth = Window.Current.Bounds.Width;
                if (windowWidth >= 1366) return "FullScreenLandscapeOrWide";
                return "FilledOrNarrow";
            }

            // Im Hochformat oder bei angedockter Anwendung mit dem visuellen Standardzustandsnamen starten, dann ein
            // Suffix hinzufügen, wenn Details anstatt der Liste angezeigt werden
            var defaultStateName = base.DetermineVisualState(viewState);
            return logicalPageBack ? defaultStateName + "_Detail" : defaultStateName;
        }

        #endregion
        
        // Bei betätigen des Speicherbuttons wird das aktuell ausgewählte Element festgestellt und die Nummer von diesem 
        // (es gibt 7 Tagesgerichte). Anschließend wird die Save Methode in der rezept Klasse aufgerufen und der Button collapsed.
        private async void Button1_Click(object sender, RoutedEventArgs e)
        {
            Rezept rezept = new Rezept();
            rezept = SampleDataSource.GetRezept();
            string dataname;
            var selectedItem = (SampleDataItem)this.itemsViewSource.View.CurrentItem;
            int itemnumber = int.Parse(selectedItem.UniqueId.Substring(selectedItem.UniqueId.Length - 1));
            dataname = await rezept.Save(itemnumber);
            SampleDataSource.AddDateiname(dataname);
            SampleDataSource.AddItem((SampleDataItem)this.itemsViewSource.View.CurrentItem, dataname);
            Speichern.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
        }

        // Hier wird das ausgewählte Element gelöscht und anschließend das nächste Element ausgewählt (bzw. falls es das letzte war
        // das vorige)
        private async void Button2_Click(object sender, RoutedEventArgs e)
        {
            

            if (itemsViewSource.View.MoveCurrentToNext())
            {
                await SampleDataSource.RemoveItem(itemsViewSource.View.CurrentPosition - 1);

                if (itemsViewSource.View.CurrentItem == null)
                {
                    Speichern.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
                    Loeschen.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
                    Rate.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
                }
            }
            else  
            {
                itemsViewSource.View.MoveCurrentToPosition(itemsViewSource.View.CurrentPosition - 2);
                
                   await SampleDataSource.RemoveItem(itemsViewSource.View.CurrentPosition+1);

                    if (itemsViewSource.View.CurrentItem == null)
                    {
                        Speichern.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
                        Loeschen.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
                        Rate.Visibility = Windows.UI.Xaml.Visibility.Collapsed;
                    }
                }

                }


        //Neues Rezept hinzufügen

        private void NeuErstellen_Click_1(object sender, RoutedEventArgs e)
        {
            this.Frame.Navigate(typeof(EigenesRezeptSpeichern));
        }

        // Falls sich das Rating ändert wird eine modifizierte Speichermethode in der Rezept Klasse aufgerufen, die alte Datei
        // wird mit einer mit neuem Rating ersetzt.
        private async void RateChange(object sender, ValueChangedEventArgs<double> e)
        {
            if(this.itemsViewSource!=null)
            {  
                Rezept rezept = new Rezept();
                var selectedItem = (SampleDataItem)this.itemsViewSource.View.CurrentItem;
                await rezept.Ratingchange(Rate.Value, selectedItem.Dataname);

              
            }



        }

    }
}
